/*	pip.c	1.5	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"
#include "cpmfio.h"

/************************************************************************
 * NAME:	piptext() & pipbin()
 *
 * DESCR:	Used by cpm_copyin() to perform either a text or binary
 *		copy.
 *
 * ARGS:	
 *
 * RETURNS:	(void)
 *
 * NOTES:	- errors are ignored
 ************************************************************************/
static void
piptext(C_FILE *cid, FILE *ufid)
{
    int c = 0;

    while ((c = getc(ufid)) != EOF) {
	if (c == '\n')  {
	    if (c_putc('\r', cid) == EOF) 
		break;
	}
	if (c_putc(c, cid) == EOF) 
	    break;
    }
}

static void
pipbin(C_FILE *cid, FILE *ufid)
{
    char buf[128];
    int	c;

    while (read(fileno(ufid), buf, 128) != 0) {
	if ((c=cpm_file_write(cid, buf, 128)) != 128) {
	    break;
	}
    }
}

/************************************************************************
 * NAME:	cpm_copyin()
 *
 * DESCR:	copy a file from the local filesystem to CPM.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:	
 ************************************************************************/
int
cpm_copyin(struct cpmfs *cpmfs, char unixfile[], char cpmfile[], int bin)
{

	FILE *ufid;
	char name[9], ext[4];
	C_FILE *cid;
	int flag = 0;

	if ((ufid = fopen(unixfile, "r")) == NULL) {
		return(FALSE);
	}
	if (!(cpm_namesep(cpmfile, name, ext))) {
		return(FALSE);
	}
	if (bin) {
		flag = BINARY;
	}
	if ((cid = cpm_file_creat(cpmfs, name, ext, flag)) == NULL) {
		return(FALSE);
	}
	if (bin) {
		pipbin(cid, ufid);
	} else {
		piptext(cid, ufid);
	}
	cpm_file_close(cid); 
	fclose(ufid);

	return(TRUE);
}
